<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneSchnellbuchung;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Schnellbuchung;

/**
 * Class StageSchnellbuchung
 *
 * @package Vtours\Website\Mapper
 */
class StageSchnellbuchung implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneSchnellbuchung;
    }

    /**
     * handle
     *
     * @param VtoursBuehneSchnellbuchung $object
     * @param string                     $language
     *
     * @return Schnellbuchung
     */
    public function handle($object, $language)
    {

        $image = new Image();
        if (!empty($object->getBackgroundPicture())) {
            $image->build($object->getBackgroundPicture(), null);
        }

        return (new Schnellbuchung())
            ->setObjectId($object->getId())
            ->setSubmitForm($object->getSubmitForm())
            ->setBackgroundPicture($image)
            ->setAllInclusive($object->getAllinclusive())
            ->setHotel($object->getHotel())
            ->setLastMinute($object->getLastMinute())
            ->setAirportOfDeparture($object->getAirportOfDeparture())
            ->setLocation($object->getLocation())
            ->setTraveller($object->getTraveller())
            ->setAdult($object->getAdult())
            ->setAdultInformation($object->getAdultInformation())
            ->setTeenager($object->getTeenager())
            ->setTeenagerInformation($object->getTeenagerInformation())
            ->setChild($object->getChild())
            ->setChildInformation($object->getChildInformation())
            ->setInfant($object->getInfant())
            ->setInfantInformation($object->getInfantInformation())
            ->setSubmitCalendar($object->getSubmitCalendar())
            ->setDays($object->getDays())
            ->setTravelDate($object->getTravelDate())
            ->setFlexible($object->getFlexible())
            ->setFixed($object->getFixed())
            ->setTravelTime($object->getTravelTime());
    }
}
