<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class AbstractStage
 *
 * @package Vtours\Website\Model\Stage
 */
abstract class AbstractStage
{

    /**
     * @var int
     */
    protected $objectId;

    /**
     * @var string
     */
    protected $templateName = 'template-not-set.twig';

    /**
     * @return int
     */
    final public function getObjectId()
    {
        return $this->objectId;
    }

    /**
     * @param int $objectId
     *
     * @return $this
     */
    final public function setObjectId($objectId)
    {
        $this->objectId = $objectId;

        return $this;
    }

    /**
     * @return string
     */
    final public function getTemplateName()
    {
        return $this->templateName;
    }
}
