<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage\Element;

/**
 * Class InspirationBig
 *
 * @package Vtours\Website\Model\Stage\Element
 */
class InspirationBig
{

    /**
     * @var Angebot
     */
    private $offer;

    /**
     * @var Image
     */
    private $picture;

    /**
     * @var Link
     */
    private $link;


    /**
     * @return Image
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param Image $picture
     *
     * @return InspirationBig
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;

        return $this;
    }

    /**
     * @return Angebot
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * @param Angebot $offer
     *
     * @return InspirationBig
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;

        return $this;
    }

    /**
     * @return Link
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @param Link $link
     *
     * @return InspirationBig
     */
    public function setLink($link)
    {
        $this->link = $link;

        return $this;
    }

}
