<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage\Element;

/**
 * Class Link
 *
 * @package Vtours\Website\Model\Stage\Element
 */
class Link
{

    /**
     * @var string
     */
    private $text;

    /**
     * @var string
     */
    private $href;

    /**
     * @var string
     */
    private $target;

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $style;

    /**
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * @param string $text
     *
     * @return Link
     */
    public function setText($text)
    {
        $this->text = $text;

        return $this;
    }

    /**
     * @return string
     */
    public function getHref()
    {
        return $this->href;
    }

    /**
     * @param string $href
     *
     * @return Link
     */
    public function setHref($href)
    {
        $this->href = $href;

        return $this;
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * @param string $target
     *
     * @return Link
     */
    public function setTarget($target)
    {
        $this->target = $target;

        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Link
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return string
     */
    public function getStyle()
    {
        return $this->style;
    }

    /**
     * @param string $style
     *
     * @return Link
     */
    public function setStyle($style)
    {
        $this->style = $style;

        return $this;
    }

    /**
     * build
     *
     * @param \Pimcore\Model\Object\Data\Link $link
     *
     * @return $this
     */
    public function build(\Pimcore\Model\Object\Data\Link $link)
    {

        $this->target = $link->getTarget();
        $this->href = $link->getHref();
        $this->title = $link->getTitle();
        $this->text = $link->getText();

        return $this;
    }
}
