<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Testimonial;

/**
 * Class Newsletter
 *
 * @package Vtours\Website\Model\Stage
 */
class Newsletter extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'newsletter.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var Testimonial
     */
    private $testimonial;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $labelButton;

    /**
     * @var string
     */
    private $content;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return Newsletter
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return Testimonial
     */
    public function getTestimonial()
    {
        return $this->testimonial;
    }

    /**
     * @param Testimonial $testimonial
     *
     * @return Newsletter
     */
    public function setTestimonial($testimonial)
    {
        $this->testimonial = $testimonial;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return Newsletter
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabelButton()
    {
        return $this->labelButton;
    }

    /**
     * @param string $labelButton
     *
     * @return Newsletter
     */
    public function setLabelButton($labelButton)
    {
        $this->labelButton = $labelButton;

        return $this;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string $content
     *
     * @return Newsletter
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }
}
