<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;


use Pimcore\Model\Object\VtoursBuehneCountdown;
use Vtours\Website\Model\Stage\Countdown;
use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;

/**
 * Class StageCountdown
 *
 * @package Vtours\Website\Mapper
 */
class StageCountdown implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneCountdown;
    }

    /**
     * handle
     *
     * @param VtoursBuehneCountdown $object
     * @param string                $language
     *
     * @return Countdown
     */
    public function handle($object, $language)
    {

        $pictureXS = new Image();
        if (!empty($object->getBackgroundPictureXS())) {
            $pictureXS->build($object->getBackgroundPictureXS(), $language);
        }

        $pictureSM = new Image();
        if (!empty($object->getBackgroundPictureSM())) {
            $pictureSM->build($object->getBackgroundPictureSM(), $language);
        }

        $pictureMD = new Image();
        if (!empty($object->getBackgroundPictureMD())) {
            $pictureMD->build($object->getBackgroundPictureMD(), $language);
        }

        $pictureLG = new Image();
        if (!empty($object->getBackgroundPictureLG())) {
            $pictureLG->build($object->getBackgroundPictureLG(), $language);
        }

        $offerArray = [];
        if (!empty($object->getOffer())) {
            foreach ($object->getOffer() as $offer) {
                if ($offer->isPublished()) {
                    $offerArray[] = (new Angebot())->build($offer, $language);
                }
            }
        }

        /**
         * we need a DateTime object
         */
        $dateTime = \DateTime::createFromFormat(\DateTime::W3C, $object->getEndTime()->toW3cString());
        $dateTime->setTimezone($object->getEndTime()->getTimezone());

        return (new Countdown())
            ->setObjectId($object->getId())
            ->setTitle($object->getTitle())
            ->setEndTime($dateTime)
            ->setEndText($object->getEndText())
            ->setFirstOfferHighlighted($object->getFirstOfferHighlighted())
            ->setBackgroundPictureXS($pictureXS)
            ->setBackgroundPictureSM($pictureSM)
            ->setBackgroundPictureMD($pictureMD)
            ->setBackgroundPictureLG($pictureLG)
            ->setOffer($offerArray);
    }
}
