<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneHero;
use Pimcore\Model\Object\VtoursDatenAngebot;
use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Hero;

/**
 * Class StageHero
 *
 * @package Vtours\Website\Mapper
 */
class StageHero implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneHero;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $pictureXS = new Image();
        if (!empty($object->getBackgroundPictureXS($language))) {
            $pictureXS->build($object->getBackgroundPictureXS($language), $language);
        }

        $pictureSM = new Image();
        if (!empty($object->getBackgroundPictureSM($language))) {
            $pictureSM->build($object->getBackgroundPictureSM($language), $language);
        }

        $pictureMD = new Image();
        if (!empty($object->getBackgroundPictureMD($language))) {
            $pictureMD->build($object->getBackgroundPictureMD($language), $language);
        }

        $pictureLG = new Image();
        if (!empty($object->getBackgroundPictureLG($language))) {
            $pictureLG->build($object->getBackgroundPictureLG($language), $language);
        }

        $offer = new Angebot();
        if (!empty($object->getOffer())) {
            /**
             * @var VtoursDatenAngebot $offerPimcore
             */
            $offerPimcore = $object->getOffer()[0];
            if ($offerPimcore->isPublished()) {
                $offer->build($offerPimcore, $language);
            }
        }
        $regionIds = [];
        if (!empty($object->getRegions())) {
            /**
             * @var VtoursDatenRegion $regionPimcore
             */
            foreach ($object->getRegions() as $regionPimcore) {
                if ($regionPimcore->isPublished()) {
                    $regionIds = $regionPimcore->getRegionIFFCode();
                }
            }
        }

        return (new Hero())
            ->setObjectId($object->getId())
            ->setBackgroundPictureXS($pictureXS)
            ->setBackgroundPictureSM($pictureSM)
            ->setBackgroundPictureMD($pictureMD)
            ->setBackgroundPictureLG($pictureLG)
            ->setOffer($offer)
            ->setRegionIds($regionIds);
    }
}
