<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneTopleiste;
use Vtours\Website\Model\Stage\Topleiste;

/**
 * Class StageTopLeiste
 *
 * @package Vtours\Website\Mapper
 */
class StageTopLeiste implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneTopleiste;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $elements = $object->getElements($language);

        $items = [];
        foreach ($elements as $element) {

            $items[] = $element['item']->getData();
        }

        return (new Topleiste())
            ->setObjectId($object->getId())
            ->setElements($items)
            ->setLabelMyBooking($object->getLabelMyBooking($language));
    }
}
