<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model;

use Doctrine\Common\Cache\CacheProvider;
use Vtours\Website\Model\Navigation\Route;

/**
 * Class Routing
 *
 * @package Vtours\Website\Model
 */
class Routing
{

    /**
     * @var string
     */
    const CACHE_PREFIX = 'vtours_route_';

    /**
     * @var string
     */
    private $cacheKey = '';

    /**
     * @var CacheProvider
     */
    private $cacheDriver;

    /**
     * @var Route[]
     */
    private $routes = [];

    /**
     * Routing constructor.
     */
    public function __construct()
    {
        $this->cacheKey = static::CACHE_PREFIX . hash('sha256', 'routes');
    }

    /**
     * @return Route[]
     */
    public function getRoutes()
    {
        return $this->routes;
    }

    /**
     * @param Route[] $routes
     *
     * @return Routing
     */
    public function setRoutes($routes)
    {
        $this->routes = $routes;

        return $this;
    }

    /**
     * @return string
     */
    public function getCacheKey()
    {
        return $this->cacheKey;
    }

    /**
     * @param string $cacheKey
     *
     * @return Routing
     */
    public function setCacheKey($cacheKey)
    {
        $this->cacheKey = $cacheKey;

        return $this;
    }

    /**
     * @return CacheProvider
     */
    public function getCacheDriver()
    {
        return $this->cacheDriver;
    }

    /**
     * @param CacheProvider $cacheDriver
     *
     * @return Routing
     */
    public function setCacheDriver($cacheDriver)
    {
        $this->cacheDriver = $cacheDriver;

        return $this;
    }

    /**
     * save
     */
    public function save()
    {
        $this->cacheDriver->save($this->cacheKey, $this->routes);
    }

    /**
     * load
     */
    public function load()
    {
        $routes = $this->cacheDriver->fetch($this->cacheKey);

        if (!empty($routes) && is_array($routes)) {
            $this->routes = $routes;
        }
    }
}
