<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;

/**
 * Class Countdown
 *
 * @package Vtours\Website\Model\Stage
 */
class Countdown extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'countdown.twig';

    /**
     * @var string
     */
    private $title;

    /**
     * @var \DateTime
     */
    private $endTime;

    /**
     * @var string
     */
    private $endText;
    /**
     * @var bool
     */
    private $firstOfferHighlighted;

    /**
     * @var Image
     */
    private $backgroundPictureXS;

    /**
     * @var Image
     */
    private $backgroundPictureSM;

    /**
     * @var Image
     */
    private $backgroundPictureMD;

    /**
     * @var Image
     */
    private $backgroundPictureLG;

    /**
     * @var Angebot[]
     */
    private $offer;

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     *
     * @return Countdown
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->endTime;
    }

    /**
     * @param \DateTime $endTime
     *
     * @return Countdown
     */
    public function setEndTime($endTime)
    {
        $this->endTime = $endTime;

        return $this;
    }

    /**
     * @return string
     */
    public function getEndText()
    {
        return $this->endText;
    }

    /**
     * @param string $endText
     *
     * @return Countdown
     */
    public function setEndText($endText)
    {
        $this->endText = $endText;

        return $this;
    }

    /**
     * @return bool
     */
    public function isFirstOfferHighlighted()
    {
        return $this->firstOfferHighlighted;
    }

    /**
     * @param bool $firstOfferHighlighted
     *
     * @return Countdown
     */
    public function setFirstOfferHighlighted($firstOfferHighlighted)
    {
        $this->firstOfferHighlighted = $firstOfferHighlighted;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureXS()
    {
        return $this->backgroundPictureXS;
    }

    /**
     * @param Image $backgroundPictureXS
     *
     * @return Countdown
     */
    public function setBackgroundPictureXS($backgroundPictureXS)
    {
        $this->backgroundPictureXS = $backgroundPictureXS;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureSM()
    {
        return $this->backgroundPictureSM;
    }

    /**
     * @param Image $backgroundPictureSM
     *
     * @return Countdown
     */
    public function setBackgroundPictureSM($backgroundPictureSM)
    {
        $this->backgroundPictureSM = $backgroundPictureSM;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureMD()
    {
        return $this->backgroundPictureMD;
    }

    /**
     * @param Image $backgroundPictureMD
     *
     * @return Countdown
     */
    public function setBackgroundPictureMD($backgroundPictureMD)
    {
        $this->backgroundPictureMD = $backgroundPictureMD;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureLG()
    {
        return $this->backgroundPictureLG;
    }

    /**
     * @param Image $backgroundPictureLG
     *
     * @return Countdown
     */
    public function setBackgroundPictureLG($backgroundPictureLG)
    {
        $this->backgroundPictureLG = $backgroundPictureLG;

        return $this;
    }

    /**
     * @return Angebot[]
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * @param Angebot[] $offer
     *
     * @return Countdown
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;

        return $this;
    }

    /**
     * getBackgroundPicture
     *
     * @param string $size
     *
     * @return Image
     */
    public function getBackgroundPicture($size)
    {
        $size = strtolower($size);

        $picture = $this->backgroundPictureLG;

        if ($size == 'md' && !empty($this->backgroundPictureMD->getUrl())) {
            $picture = (empty($this->backgroundPictureMD->getUrl()) ? $this->backgroundPictureLG : $this->backgroundPictureMD);
        }

        if ($size == 'sm') {
            if (!empty($this->backgroundPictureSM->getUrl())) {
                $picture = $this->backgroundPictureSM;
            } elseif (!empty($this->backgroundPictureMD->getUrl())) {
                $picture = $this->backgroundPictureMD;
            }
        }

        if ($size == 'xs') {
            if (!empty($this->backgroundPictureXS->getUrl())) {
                $picture = $this->backgroundPictureXS;
            } elseif (!empty($this->backgroundPictureSM->getUrl())) {
                $picture = $this->backgroundPictureSM;
            } elseif (!empty($this->backgroundPictureMD->getUrl())) {
                $picture = $this->backgroundPictureMD;
            }
        }

        return $picture;
    }
}
