<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneHintergrundbildMitLink;
use Vtours\Website\Model\Stage\BildLink;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;

/**
 * Class StageBildLink
 *
 * @package Vtours\Website\Mapper
 */
class StageBildLink implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneHintergrundbildMitLink;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        /**
         * @var \Pimcore\Model\Object\Data\Link $link
         */
        $link = $object->getLink($language);

        $linkModel = new Link();
        if (!empty($link)) {
            $linkModel
                ->setTarget($link->getTarget())
                ->setHref($link->getHref())
                ->setTitle($link->getTitle())
                ->setText($link->getText());
        }

        $pictureXS = new Image();
        if (!empty($object->getBackgroundPictureXS())) {
            $pictureXS->build($object->getBackgroundPictureXS(), $language);
        }

        $pictureSM = new Image();
        if (!empty($object->getBackgroundPictureSM())) {
            $pictureSM->build($object->getBackgroundPictureSM(), $language);
        }

        $pictureMD = new Image();
        if (!empty($object->getBackgroundPictureMD())) {
            $pictureMD->build($object->getBackgroundPictureMD(), $language);
        }

        $pictureLG = new Image();
        if (!empty($object->getBackgroundPictureLG())) {
            $pictureLG->build($object->getBackgroundPictureLG(), $language);
        }

        return (new BildLink())
            ->setObjectId($object->getId())
            ->setBackgroundPictureXS($pictureXS)
            ->setBackgroundPictureSM($pictureSM)
            ->setBackgroundPictureMD($pictureMD)
            ->setBackgroundPictureLG($pictureLG)
            ->setLink($linkModel)
            ->setLinkText($object->getLinkText($language));
    }
}
