<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneNutzerversprechen;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Nutzerversprechen;

/**
 * Class StagePromise
 *
 * @package Vtours\Website\Mapper
 */
class StagePromise implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneNutzerversprechen;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $image = (new Image())->build($object->getRingPicture($language), $language);

        return (new Nutzerversprechen())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setLabelFlight($object->getFlight($language))
            ->setLabelAccomodation($object->getAccommodation($language))
            ->setLabelTransfer($object->getTransfer($language))
            ->setLabelInsurance($object->getTravelInsurance($language))
            ->setText($object->getRingText($language))
            ->setPicture($image);
    }
}
