<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneVfamilyangebote;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;
use Vtours\Website\Model\Stage\Element\TitleText;
use Vtours\Website\Model\Stage\VfamilyAngebote;

/**
 * Class StageVfamilyAngebote
 *
 * @package Vtours\Website\Mapper
 */
class StageVfamilyAngebote implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneVfamilyangebote;
    }

    /**
     * handle
     *
     * @param VtoursBuehneVfamilyAngebote $object
     * @param string                      $language
     *
     * @return VfamilyAngebote
     */
    public function handle($object, $language)
    {

        /**
         * @var \Pimcore\Model\Object\Fieldcollection\Data\VtoursManualOffer $offer
         */
        $offerArray = [];
        if (!empty($object->getOffers())) {
            foreach ($object->getOffers() as $offer) {
                $link = new Link();
                if (!empty($offer->getLink())) {
                    $link->build($offer->getLink());
                }

                $image = new Image();
                if (!empty($offer->getPicture())) {
                    $image->build($offer->getPicture(), $language);
                }

                $offerArray[] = (new TitleText())
                    ->setTitle($offer->getTitle())
                    ->setContent($offer->getContent())
                    ->setLink($link)
                    ->setImage($image);
            }
        }

        return (new VfamilyAngebote())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle())
            ->setOffers($offerArray);
    }
}
