<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\TitleText;

/**
 * Class Akkordeon
 *
 * @package Vtours\Website\Model\Stage
 */
class Akkordeon extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'akkordeon.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var TitleText[]
     */
    private $elements;

    /**
     * @var boolean
     */
    private $firstElementActivated;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return $this
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return TitleText[]
     */
    public function getElements()
    {
        return $this->elements;
    }

    /**
     * @param TitleText[] $elements
     *
     * @return Akkordeon
     */
    public function setElements($elements)
    {
        $this->elements = $elements;

        return $this;
    }

    /**
     * @return bool
     */
    public function isFirstElementActivated()
    {
        return $this->firstElementActivated;
    }

    /**
     * @param bool $firstElementActivated
     *
     * @return Akkordeon
     */
    public function setFirstElementActivated($firstElementActivated)
    {
        $this->firstElementActivated = $firstElementActivated;

        return $this;
    }
}
