<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneReisetipps;
use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\InspirationElement;
use Vtours\Website\Model\Stage\Element\Link;
use Vtours\Website\Model\Stage\Reisetipps;

/**
 * Class StageReisetipps
 *
 * @package Vtours\Website\Mapper\Handler
 */
class StageReisetipps implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneReisetipps;
    }

    /**
     * handle
     *
     * @param VtoursBuehneReisetipps $object
     * @param string                 $language
     *
     * @return Reisetipps
     */
    public function handle($object, $language)
    {

        /**
         * @var \Pimcore\Model\Object\Fieldcollection\Data\VtoursReisetippsElement $tip
         */
        $tipArray = [];

        if (!empty($object->getTips())) {
            foreach ($object->getTips() as $tip) {
                $offer = new Angebot();
                $tipOffer = $tip->getOffer()[0];
                if (!empty($tipOffer) && $tipOffer->isPublished()) {
                    $offer->build($tipOffer, $language);
                }

                $picture = new Image();
                if (!empty($tip->getPicture())) {
                    $picture->build($tip->getPicture(), $language);
                }

                $link = new Link();
                if (!empty($tip->getLink())) {
                    $link->build($tip->getLink());
                }

                $tipArray[] = (new InspirationElement())
                    ->setOffer($offer)
                    ->setPicture($picture)
                    ->setLink($link);
            }
        }


        return (new Reisetipps())
            ->setObjectId($object->getId())
            ->setTips($tipArray);
    }
}
