<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\Data\BlockElement;
use Pimcore\Model\Object\VtoursBuehneReisezielSlider;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;
use Vtours\Website\Model\Stage\Element\TravelDestination;
use Vtours\Website\Model\Stage\ReisezieleSlider;

/**
 * Class StageTravelDestinationSlider
 *
 * @package Vtours\Website\Mapper
 */
class StageTravelDestinationSlider implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneReisezielSlider;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $elements = $object->getElements($language);

        $travelDestinationElements = [];
        foreach ($elements as $element) {

            /**
             * @var \Pimcore\Model\Object\Data\Link $link
             */
            $link = $element['linkTarget']->getData();

            $linkModel = new Link();
            if (!empty($link)) {
                $linkModel->setTarget($link->getTarget())
                    ->setHref($link->getHref())
                    ->setTitle($link->getTitle())
                    ->setText($link->getText());
            }

            $travelDestination = (new TravelDestination())
                ->setContinent($element['continent']->getData())
                ->setCountry($element['country']->getData())
                ->setLink($linkModel);

            if ($element['picture'] instanceof BlockElement) {
                $image = (new Image())->build($element['picture']->getData(), $language);
                $travelDestination->setPicture($image);
            }

            $travelDestinationElements[] = $travelDestination;
        }

        return (new ReisezieleSlider())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setElements($travelDestinationElements);
    }
}
