<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\TitleText;

/**
 * Class FooterVersprechen
 *
 * @package Vtours\Website\Model\Stage
 */
class FooterVersprechen extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'footer-versprechen.twig';

    /**
     * @var TitleText
     */
    private $element1;

    /**
     * @var TitleText
     */
    private $element2;

    /**
     * @var TitleText
     */
    private $element3;

    /**
     * @var TitleText
     */
    private $element4;

    /**
     * @return TitleText
     */
    public function getElement1()
    {
        return $this->element1;
    }

    /**
     * @param TitleText $element1
     *
     * @return FooterVersprechen
     */
    public function setElement1($element1)
    {
        $this->element1 = $element1;
        return $this;
    }

    /**
     * @return TitleText
     */
    public function getElement2()
    {
        return $this->element2;
    }

    /**
     * @param TitleText $element2
     *
     * @return FooterVersprechen
     */
    public function setElement2($element2)
    {
        $this->element2 = $element2;
        return $this;
    }

    /**
     * @return TitleText
     */
    public function getElement3()
    {
        return $this->element3;
    }

    /**
     * @param TitleText $element3
     *
     * @return FooterVersprechen
     */
    public function setElement3($element3)
    {
        $this->element3 = $element3;
        return $this;
    }

    /**
     * @return TitleText
     */
    public function getElement4()
    {
        return $this->element4;
    }

    /**
     * @param TitleText $element4
     *
     * @return FooterVersprechen
     */
    public function setElement4($element4)
    {
        $this->element4 = $element4;
        return $this;
    }
}
