<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class HtmlInhalt
 *
 * @package Vtours\Website\Model\Stage
 */
class HtmlInhalt extends AbstractStage
{
    /**
     * @var string
     */
    protected $templateName = 'html.twig';

    /**
     * @var string
     */
    private $content;

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string $content
     *
     * @return HtmlInhalt
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }
}
