<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneBreadcrumb;
use Vtours\Website\Model\Stage\Breadcrumb;

class StageBreadcrumb implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneBreadcrumb;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {

        return (new Breadcrumb())
            ->setObjectId($object->getId());
    }
}
