<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneHtmlInhalt;
use Vtours\Website\Model\Stage\HtmlInhalt;

/**
 * Class StageHtmlContent
 *
 * @package Vtours\Website\Mapper
 */
class StageHtmlContent implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneHtmlInhalt;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        return (new HtmlInhalt())
            ->setObjectId($object->getId())
            ->setContent($object->getContent($language));
    }
}
