<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class Formular
 *
 * @package Vtours\Website\Model\Stage
 */
class Formular extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'formular.twig';

    /**
     * @var string
     */
    private $formAction;

    /**
     * @var string
     */
    private $salutation;

    /**
     * @var string
     */
    private $labelChoose;

    /**
     * @var string
     */
    private $salutationMr;

    /**
     * @var string
     */
    private $salutationMs;

    /**
     * @var string
     */
    private $firstName;

    /**
     * @var string
     */
    private $lastName;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $telephone;

    /**
     * @var string
     */
    private $subject;

    /**
     * @var array
     */
    private $subjectOptions;

    /**
     * @var string
     */
    private $message;

    /**
     * @var string
     */
    private $labelButton;

    /**
     * @return string
     */
    public function getFormAction()
    {
        return $this->formAction;
    }

    /**
     * @param string $formAction
     *
     * @return Formular
     */
    public function setFormAction($formAction)
    {
        $this->formAction = $formAction;

        return $this;
    }

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }

    /**
     * @param string $salutation
     *
     * @return Formular
     */
    public function setSalutation($salutation)
    {
        $this->salutation = $salutation;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabelChoose()
    {
        return $this->labelChoose;
    }

    /**
     * @param string $labelChoose
     *
     * @return Formular
     */
    public function setLabelChoose($labelChoose)
    {
        $this->labelChoose = $labelChoose;

        return $this;
    }

    /**
     * @return string
     */
    public function getSalutationMr()
    {
        return $this->salutationMr;
    }

    /**
     * @param string $salutationMr
     *
     * @return Formular
     */
    public function setSalutationMr($salutationMr)
    {
        $this->salutationMr = $salutationMr;

        return $this;
    }

    /**
     * @return string
     */
    public function getSalutationMs()
    {
        return $this->salutationMs;
    }

    /**
     * @param string $salutationMs
     *
     * @return Formular
     */
    public function setSalutationMs($salutationMs)
    {
        $this->salutationMs = $salutationMs;

        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     *
     * @return Formular
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     *
     * @return Formular
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return Formular
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * @param string $telephone
     *
     * @return Formular
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * @param string $subject
     *
     * @return Formular
     */
    public function setSubject($subject)
    {
        $this->subject = $subject;

        return $this;
    }

    /**
     * @return array
     */
    public function getSubjectOptions()
    {
        return $this->subjectOptions;
    }

    /**
     * @param array $subjectOptions
     *
     * @return Formular
     */
    public function setSubjectOptions($subjectOptions)
    {
        $this->subjectOptions = $subjectOptions;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     *
     * @return Formular
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabelButton()
    {
        return $this->labelButton;
    }

    /**
     * @param string $labelButton
     *
     * @return Formular
     */
    public function setLabelButton($labelButton)
    {
        $this->labelButton = $labelButton;

        return $this;
    }
}
