<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Image;

/**
 * Class Nutzerversprechen
 *
 * @package Vtours\Website\Model\Stage
 */
class Nutzerversprechen extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'nutzerversprechen.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $labelFlight;

    /**
     * @var string
     */
    private $labelAccomodation;

    /**
     * @var string
     */
    private $labelTransfer;

    /**
     * @var string
     */
    private $labelInsurance;

    /**
     * @var string
     */
    private $text;

    /**
     * @var Image
     */
    private $picture;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return Nutzerversprechen
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;
        return $this;
    }

    /**
     * @return string
     */
    public function getLabelFlight()
    {
        return $this->labelFlight;
    }

    /**
     * @param string $labelFlight
     *
     * @return Nutzerversprechen
     */
    public function setLabelFlight($labelFlight)
    {
        $this->labelFlight = $labelFlight;
        return $this;
    }

    /**
     * @return string
     */
    public function getLabelAccomodation()
    {
        return $this->labelAccomodation;
    }

    /**
     * @param string $labelAccomodation
     *
     * @return Nutzerversprechen
     */
    public function setLabelAccomodation($labelAccomodation)
    {
        $this->labelAccomodation = $labelAccomodation;
        return $this;
    }

    /**
     * @return string
     */
    public function getLabelTransfer()
    {
        return $this->labelTransfer;
    }

    /**
     * @param string $labelTransfer
     *
     * @return Nutzerversprechen
     */
    public function setLabelTransfer($labelTransfer)
    {
        $this->labelTransfer = $labelTransfer;
        return $this;
    }

    /**
     * @return string
     */
    public function getLabelInsurance()
    {
        return $this->labelInsurance;
    }

    /**
     * @param string $labelInsurance
     *
     * @return Nutzerversprechen
     */
    public function setLabelInsurance($labelInsurance)
    {
        $this->labelInsurance = $labelInsurance;
        return $this;
    }

    /**
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * @param string $text
     *
     * @return Nutzerversprechen
     */
    public function setText($text)
    {
        $this->text = $text;
        return $this;
    }

    /**
     * @return Image
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param Image $picture
     *
     * @return Nutzerversprechen
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;
        return $this;
    }
}
