<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneInformation;
use Vtours\Website\Model\Stage\Element\TitleText;
use Vtours\Website\Model\Stage\Informationen;

/**
 * Class StageInformation
 *
 * @package Vtours\Website\Mapper
 */
class StageInformation implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneInformation;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $elements = $object->getElements($language);

        $titleTextElements = [];
        foreach ($elements as $element) {
            $titleTextElements[] = (new TitleText())
                ->setTitle($element['title']->getData())
                ->setContent($element['contentShort']->getData())
                ->setAdditionalContent($element['contentLong']->getData());
        }

        return (new Informationen())
            ->setObjectId($object->getId())
            ->setLabelClose($object->getLabelClose($language))
            ->setLabelOpen($object->getLabelOpen($language))
            ->setElements($titleTextElements);
    }
}
