<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\Fieldcollection\Data\VtoursInspirationBlock;
use Pimcore\Model\Object\VtoursBuehneInspiration;
use Pimcore\Model\Object\VtoursElementInspirationBig;
use Pimcore\Model\Object\VtoursElementInspirationSmall;
use Vtours\Website\Model\Stage\Element\InspirationElement;
use Vtours\Website\Model\Stage\Inspiration;

/**
 * Class StageInspiration
 *
 * @package Vtours\Website\Mapper
 */
class StageInspiration implements HandlerInterface
{
    /**
     * @param VtoursBuehneInspiration $object
     *
     * @return bool
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneInspiration;
    }

    /**
     * @param VtoursBuehneInspiration $object
     * @param string                  $language
     *
     * @return Inspiration
     */
    public function handle($object, $language)
    {
        $inspiration = (new Inspiration())
            ->setObjectId($object->getId())
            ->setTitle($object->getTitle())
            ->setShowMore($object->getShowMore())
            ->setCircleContent($object->getCircleContent());

        /**
         * @var VtoursInspirationBlock $block
         */
        $blocks = 0;
        $lineNumber = 0;
        foreach ($object->getBlockElements() as $block) {
            foreach ($block->getBlockElement() as $element) {
                $inspirationElement = (new InspirationElement())->build($element, $language);

                if ($element instanceof VtoursElementInspirationSmall) {
                    $inspiration->addToLine($lineNumber, $inspirationElement);
                } elseif ($element instanceof VtoursElementInspirationBig) {
                    $inspiration->addToLine($lineNumber, $inspirationElement);
                }
            }

            $blocks++;

            if ($blocks % 2 == 0) {
                $lineNumber++;
            }
        }

        return $inspiration;
    }
}
