<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneNewsletter;
use Pimcore\Model\Object\VtoursElementTestimonial;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Testimonial;
use Vtours\Website\Model\Stage\Newsletter;

/**
 * Class StageNewsletter
 *
 * @package Vtours\Website\Mapper\Handler
 */
class StageNewsletter implements HandlerInterface
{

    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneNewsletter;
    }

    /**
     * handle
     *
     * @param VtoursBuehneNewsletter $object
     * @param string                 $language
     *
     * @return Newsletter
     */
    public function handle($object, $language)
    {

        $newsletter = new Newsletter();

        $testimonialArray = $object->getTestimonial();

        $picture = new Image();
        if ($testimonialArray[0] instanceof VtoursElementTestimonial && !empty($testimonialArray[0]->getPicture())) {
            $picture->build($testimonialArray[0]->getPicture(), $language);

            $testimonial = (new Testimonial())
                ->setName($testimonialArray[0]->getName())
                ->setPicture($picture)
                ->setContent($testimonialArray[0]->getContent($language));

            $newsletter->setTestimonial($testimonial);
        }

        return $newsletter
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle())
            ->setNewsletterUrl($object->getNewsletterUrl())
            ->setEmail($object->getEmail())
            ->setLabelButton($object->getLabelButton())
            ->setContent($object->getContent());
    }
}
