<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage\Element;

use Pimcore\Model\Object\VtoursElementInspirationBig;
use Pimcore\Model\Object\VtoursElementInspirationSmall;

/**
 * Class Inspiration
 *
 * @package Vtours\Website\Model\Stage\Element
 */
class InspirationElement
{

    /**
     * @var Angebot
     */
    private $offer;

    /**
     * @var Image
     */
    private $picture;

    /**
     * @var Link
     */
    private $link;

    /**
     * @var int
     */
    private $size;

    /**
     * @return Angebot
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * @param Angebot $offer
     *
     * @return InspirationElement
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;

        return $this;
    }

    /**
     * @return Image
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param Image $picture
     *
     * @return InspirationElement
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;

        return $this;
    }

    /**
     * @return Link
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @param Link $link
     *
     * @return InspirationElement
     */
    public function setLink($link)
    {
        $this->link = $link;

        return $this;
    }

    /**
     * @return int
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * @param int $size
     *
     * @return InspirationElement
     */
    public function setSize($size)
    {
        $this->size = $size;

        return $this;
    }

    /**
     * build
     *
     * @param VtoursElementInspirationBig|VtoursElementInspirationSmall $element
     * @param string                                                    $language
     *
     * @return $this
     */
    public function build($element, $language)
    {

        $this->offer = new Angebot();
        if (!empty($element->getOffer())) {
            $offer = $element->getOffer()[0];

            if ($offer->isPublished()) {
                $this->offer->build($offer, $language);
            }
        }

        $this->picture = (new Image())->build($element->getPicture(), $language);
        $this->link = (new Link())->build($element->getLink());

        if ($element instanceof VtoursElementInspirationSmall) {
            $this->size = 1;
        } elseif ($element instanceof VtoursElementInspirationBig) {
            $this->size = 2;
        }

        return $this;
    }
}
