<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Image;

/**
 * Class Schnellbuchung
 *
 * @package Vtours\Website\Model\Stage
 */
class Schnellbuchung extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'schnellbuchung.twig';

    /**
     * @var string
     */
    private $submitForm;

    /**
     * @var Image
     */
    private $backgroundPicture;

    /**
     * @var string
     */
    private $allInclusive;

    /**
     * @var string
     */
    private $hotel;

    /**
     * @var string
     */
    private $lastMinute;

    /**
     * @var string
     */
    private $airportOfDeparture;

    /**
     * @var string
     */
    private $location;

    /**
     * @var string
     */
    private $traveller;

    /**
     * @var string
     */
    private $adult;

    /**
     * @var string
     */
    private $adultInformation;

    /**
     * @var string
     */
    private $teenager;

    /**
     * @var string
     */
    private $teenagerInformation;


    /**
     * @var string
     */
    private $child;

    /**
     * @var string
     */
    private $childInformation;

    /**
     * @var string
     */
    private $infant;

    /**
     * @var string
     */
    private $infantInformation;

    /**
     * @var string
     */
    private $submitCalendar;

    /**
     * @var string
     */
    private $days;

    /**
     * @var string
     */
    private $travelDate;

    /**
     * @var string
     */
    private $flexible;

    /**
     * @var string
     */
    private $fixed;

    /**
     * @var string
     */
    private $travelTime;


    /**
     * @return string
     */
    public function getSubmitForm()
    {
        return $this->submitForm;
    }

    /**
     * @param string $submitForm
     *
     * @return Schnellbuchung
     */
    public function setSubmitForm($submitForm)
    {
        $this->submitForm = $submitForm;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPicture()
    {
        return $this->backgroundPicture;
    }

    /**
     * @param Image $backgroundPicture
     *
     * @return Schnellbuchung
     */
    public function setBackgroundPicture($backgroundPicture)
    {
        $this->backgroundPicture = $backgroundPicture;

        return $this;
    }

    /**
     * @return string
     */
    public function getAllInclusive()
    {
        return $this->allInclusive;
    }

    /**
     * @param string $allInclusive
     *
     * @return Schnellbuchung
     */
    public function setAllInclusive($allInclusive)
    {
        $this->allInclusive = $allInclusive;

        return $this;
    }

    /**
     * @return string
     */
    public function getHotel()
    {
        return $this->hotel;
    }

    /**
     * @param string $hotel
     *
     * @return Schnellbuchung
     */
    public function setHotel($hotel)
    {
        $this->hotel = $hotel;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastMinute()
    {
        return $this->lastMinute;
    }

    /**
     * @param string $lastMinute
     *
     * @return Schnellbuchung
     */
    public function setLastMinute($lastMinute)
    {
        $this->lastMinute = $lastMinute;

        return $this;
    }

    /**
     * @return string
     */
    public function getAirportOfDeparture()
    {
        return $this->airportOfDeparture;
    }

    /**
     * @param string $airportOfDeparture
     *
     * @return Schnellbuchung
     */
    public function setAirportOfDeparture($airportOfDeparture)
    {
        $this->airportOfDeparture = $airportOfDeparture;

        return $this;
    }

    /**
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * @param string $location
     *
     * @return Schnellbuchung
     */
    public function setLocation($location)
    {
        $this->location = $location;

        return $this;
    }

    /**
     * @return string
     */
    public function getTraveller()
    {
        return $this->traveller;
    }

    /**
     * @param string $traveller
     *
     * @return Schnellbuchung
     */
    public function setTraveller($traveller)
    {
        $this->traveller = $traveller;

        return $this;
    }

    /**
     * @return string
     */
    public function getAdult()
    {
        return $this->adult;
    }

    /**
     * @param string $adult
     *
     * @return Schnellbuchung
     */
    public function setAdult($adult)
    {
        $this->adult = $adult;

        return $this;
    }

    /**
     * @return string
     */
    public function getAdultInformation()
    {
        return $this->adultInformation;
    }

    /**
     * @param string $adultInformation
     *
     * @return Schnellbuchung
     */
    public function setAdultInformation($adultInformation)
    {
        $this->adultInformation = $adultInformation;

        return $this;
    }

    /**
     * @return string
     */
    public function getTeenager()
    {
        return $this->teenager;
    }

    /**
     * @param string $teenager
     *
     * @return Schnellbuchung
     */
    public function setTeenager($teenager)
    {
        $this->teenager = $teenager;

        return $this;
    }

    /**
     * @return string
     */
    public function getTeenagerInformation()
    {
        return $this->teenagerInformation;
    }

    /**
     * @param string $teenagerInformation
     *
     * @return Schnellbuchung
     */
    public function setTeenagerInformation($teenagerInformation)
    {
        $this->teenagerInformation = $teenagerInformation;

        return $this;
    }


    /**
     * @return string
     */
    public function getChild()
    {
        return $this->child;
    }

    /**
     * @param string $child
     *
     * @return Schnellbuchung
     */
    public function setChild($child)
    {
        $this->child = $child;

        return $this;
    }

    /**
     * @return string
     */
    public function getChildInformation()
    {
        return $this->childInformation;
    }

    /**
     * @param string $childInformation
     *
     * @return Schnellbuchung
     */
    public function setChildInformation($childInformation)
    {
        $this->childInformation = $childInformation;

        return $this;
    }

    /**
     * @return string
     */
    public function getInfant()
    {
        return $this->infant;
    }

    /**
     * @param string $infant
     *
     * @return Schnellbuchung
     */
    public function setInfant($infant)
    {
        $this->infant = $infant;

        return $this;
    }

    /**
     * @return string
     */
    public function getInfantInformation()
    {
        return $this->infantInformation;
    }

    /**
     * @param string $infantInformation
     *
     * @return Schnellbuchung
     */
    public function setInfantInformation($infantInformation)
    {
        $this->infantInformation = $infantInformation;

        return $this;
    }

    /**
     * @return string
     */
    public function getSubmitCalendar()
    {
        return $this->submitCalendar;
    }

    /**
     * @param string $submitCalendar
     *
     * @return Schnellbuchung
     */
    public function setSubmitCalendar($submitCalendar)
    {
        $this->submitCalendar = $submitCalendar;

        return $this;
    }

    /**
     * @return string
     */
    public function getDays()
    {
        return $this->days;
    }

    /**
     * @param string $days
     *
     * @return Schnellbuchung
     */
    public function setDays($days)
    {
        $this->days = $days;

        return $this;
    }

    /**
     * @return string
     */
    public function getTravelDate()
    {
        return $this->travelDate;
    }

    /**
     * @param string $travelDate
     *
     * @return Schnellbuchung
     */
    public function setTravelDate($travelDate)
    {
        $this->travelDate = $travelDate;

        return $this;
    }

    /**
     * @return string
     */
    public function getFlexible()
    {
        return $this->flexible;
    }

    /**
     * @param string $flexible
     *
     * @return Schnellbuchung
     */
    public function setFlexible($flexible)
    {
        $this->flexible = $flexible;

        return $this;
    }

    /**
     * @return string
     */
    public function getFixed()
    {
        return $this->fixed;
    }

    /**
     * @param string $fixed
     *
     * @return Schnellbuchung
     */
    public function setFixed($fixed)
    {
        $this->fixed = $fixed;

        return $this;
    }

    /**
     * @return string
     */
    public function getTravelTime()
    {
        return $this->travelTime;
    }

    /**
     * @param string $travelTime
     *
     * @return Schnellbuchung
     */
    public function setTravelTime($travelTime)
    {
        $this->travelTime = $travelTime;

        return $this;
    }

}
