<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneFormular;
use Vtours\Website\Model\Stage\Formular;

/**
 * Class StageFormular
 *
 * @package Vtours\Website\Mapper\Handler
 */
class StageFormular implements HandlerInterface
{
    /**
     * handles
     *
     * @param VtoursBuehneFormular $object
     *
     * @return bool
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneFormular;
    }

    /**
     * handle
     *
     * @param VtoursBuehneFormular $object
     * @param string               $language
     *
     * @return Formular
     */
    public function handle($object, $language)
    {

        $subjectOptions = $object->getSubjectOptions();

        $subjectOptionsArray = [];
        if (!empty($subjectOptions)) {
            foreach ($subjectOptions as $subjectOption) {
                $subjectOptionsArray[] = $subjectOption['subjectOption']->getData();
            }
        }

        return (new Formular())
            ->setObjectId($object->getId())
            ->setTitle($object->getTitle())
            ->setFormAction($object->getFormAction())
            ->setSalutation($object->getSalutation())
            ->setSalutationMr($object->getSalutationMr())
            ->setSalutationMs($object->getSalutationMs())
            ->setFirstName($object->getFirstName())
            ->setLastName($object->getLastName())
            ->setEmail($object->getEmail())
            ->setTelephone($object->getTelefon())
            ->setSubject($object->getSubject())
            ->setSubjectOptions($subjectOptionsArray)
            ->setMessage($object->getMessage())
            ->setLabelButton($object->getLabelButton());
    }
}
