<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneTextButton;
use Vtours\Website\Model\Stage\Element\Link;
use Vtours\Website\Model\Stage\TextButton;

/**
 * Class StageTextButton
 *
 * @package Vtours\Website\Mapper
 */
class StageTextButton implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneTextButton;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $elements = $object->getElements($language);

        $buttonElements = [];
        foreach ($elements as $element) {
            /**
             * @var \Pimcore\Model\Object\Data\Link $link
             */
            $link = $element['link']->getData();

            if ($link instanceof \Pimcore\Model\Object\Data\Link) {
                $buttonElements[] = (new Link())
                    ->setTarget($link->getTarget())
                    ->setHref($link->getHref())
                    ->setTitle($link->getTitle())
                    ->setText($link->getText())
                    ->setStyle($element['style']->getData());
            }
        }

        return (new TextButton())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setContent($object->getContent($language))
            ->setElements($buttonElements);
    }
}
