<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage\Element;

use Pimcore\Model\Object\VtoursDatenAngebot;

/**
 * Class Angebot
 *
 * @package Vtours\Website\Model\Stage\Element
 */
class Angebot
{

    /**
     * @var string
     */
    private $hotelName;

    /**
     * @var string
     */
    private $location;

    /**
     * @var string
     */
    private $country;

    /**
     * @var int
     */
    private $category;

    /**
     * @var array
     */
    private $maxTemperature;

    /**
     * @var Image
     */
    private $hotelPicture;

    /**
     * @var string
     */
    private $offerId;

    /**
     * @var float
     */
    private $price;

    /**
     * @var string
     */
    private $priceUnit;

    /**
     * @var string
     */
    private $priceUnitAbbreviation;

    /**
     * @var string
     */
    private $meal;

    /**
     * @var string
     */
    private $roomType;

    /**
     * @var int
     */
    private $duration;

    /**
     * @var bool
     */
    private $flight;

    /**
     * @var bool
     */
    private $transfer;

    /**
     * @var Link
     */
    private $deepLink;

    /**
     * @var float
     */
    private $priceCustom;

    /**
     * @var string
     */
    private $priceCustomUnit;

    /**
     * @var string
     */
    private $priceCustomAbbreviation;

    /**
     * @var bool
     */
    private $limitedOffer;

    /**
     * @var bool
     */
    private $tip;

    /**
     * @var bool
     */
    private $vFamily;

    /**
     * @var bool
     */
    private $bigOffer;

    /**
     * @var Image
     */
    private $picture;

    /**
     * @var string
     */
    private $offertype;


    /**
     * @return string
     */
    public function getHotelName()
    {
        return $this->hotelName;
    }

    /**
     * @param string $hotelName
     *
     * @return Angebot
     */
    public function setHotelName($hotelName)
    {
        $this->hotelName = $hotelName;

        return $this;
    }

    /**
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * @param string $location
     *
     * @return Angebot
     */
    public function setLocation($location)
    {
        $this->location = $location;

        return $this;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param string $country
     *
     * @return Angebot
     */
    public function setCountry($country)
    {
        $this->country = $country;

        return $this;
    }

    /**
     * @return int
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * @param int $category
     *
     * @return Angebot
     */
    public function setCategory($category)
    {
        $this->category = $category;

        return $this;
    }

    /**
     * @return array
     */
    public function getMaxTemperature()
    {
        return $this->maxTemperature;
    }

    /**
     * @param array $maxTemperature
     *
     * @return Angebot
     */
    public function setMaxTemperature($maxTemperature)
    {
        $this->maxTemperature = $maxTemperature;

        return $this;
    }

    /**
     * @return Image
     */
    public function getHotelPicture()
    {
        return $this->hotelPicture;
    }

    /**
     * @param Image $hotelPicture
     *
     * @return Angebot
     */
    public function setHotelPicture($hotelPicture)
    {
        $this->hotelPicture = $hotelPicture;

        return $this;
    }

    /**
     * @return string
     */
    public function getOfferId()
    {
        return $this->offerId;
    }

    /**
     * @param string $offerId
     *
     * @return Angebot
     */
    public function setOfferId($offerId)
    {
        $this->offerId = $offerId;

        return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param float $price
     *
     * @return Angebot
     */
    public function setPrice($price)
    {
        $this->price = $price;

        return $this;
    }

    /**
     * @return string
     */
    public function getPriceUnit()
    {
        return $this->priceUnit;
    }

    /**
     * @param string $priceUnit
     *
     * @return Angebot
     */
    public function setPriceUnit($priceUnit)
    {
        $this->priceUnit = $priceUnit;

        return $this;
    }

    /**
     * @return string
     */
    public function getPriceUnitAbbreviation()
    {
        return $this->priceUnitAbbreviation;
    }

    /**
     * @param string $priceUnitAbbreviation
     *
     * @return Angebot
     */
    public function setPriceUnitAbbreviation($priceUnitAbbreviation)
    {
        $this->priceUnitAbbreviation = $priceUnitAbbreviation;

        return $this;
    }

    /**
     * @return string
     */
    public function getMeal()
    {
        return $this->meal;
    }

    /**
     * @param string $meal
     *
     * @return Angebot
     */
    public function setMeal($meal)
    {
        $this->meal = $meal;

        return $this;
    }

    /**
     * @return string
     */
    public function getRoomType()
    {
        return $this->roomType;
    }

    /**
     * @param string $roomType
     *
     * @return Angebot
     */
    public function setRoomType($roomType)
    {
        $this->roomType = $roomType;

        return $this;
    }

    /**
     * @return int
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * @param int $duration
     *
     * @return Angebot
     */
    public function setDuration($duration)
    {
        $this->duration = $duration;

        return $this;
    }

    /**
     * @return bool
     */
    public function isFlight()
    {
        return $this->flight;
    }

    /**
     * @param bool $flight
     *
     * @return Angebot
     */
    public function setFlight($flight)
    {
        $this->flight = $flight;

        return $this;
    }

    /**
     * @return bool
     */
    public function isTransfer()
    {
        return $this->transfer;
    }

    /**
     * @param bool $transfer
     *
     * @return Angebot
     */
    public function setTransfer($transfer)
    {
        $this->transfer = $transfer;

        return $this;
    }

    /**
     * @return Link
     */
    public function getDeepLink()
    {
        return $this->deepLink;
    }

    /**
     * @param Link $deepLink
     *
     * @return Angebot
     */
    public function setDeepLink($deepLink)
    {
        $this->deepLink = $deepLink;

        return $this;
    }

    /**
     * @return float
     */
    public function getPriceCustom()
    {
        return $this->priceCustom;
    }

    /**
     * @param float $priceCustom
     *
     * @return Angebot
     */
    public function setPriceCustom($priceCustom)
    {
        $this->priceCustom = $priceCustom;

        return $this;
    }

    /**
     * @return string
     */
    public function getPriceCustomUnit()
    {
        return $this->priceCustomUnit;
    }

    /**
     * @param string $priceCustomUnit
     *
     * @return Angebot
     */
    public function setPriceCustomUnit($priceCustomUnit)
    {
        $this->priceCustomUnit = $priceCustomUnit;

        return $this;
    }

    /**
     * @return string
     */
    public function getPriceCustomAbbreviation()
    {
        return $this->priceCustomAbbreviation;
    }

    /**
     * @param string $priceCustomAbbreviation
     *
     * @return Angebot
     */
    public function setPriceCustomAbbreviation($priceCustomAbbreviation)
    {
        $this->priceCustomAbbreviation = $priceCustomAbbreviation;

        return $this;
    }

    /**
     * @return bool
     */
    public function isLimitedOffer()
    {
        return $this->limitedOffer;
    }

    /**
     * @param bool $limitedOffer
     *
     * @return Angebot
     */
    public function setLimitedOffer($limitedOffer)
    {
        $this->limitedOffer = $limitedOffer;

        return $this;
    }

    /**
     * @return bool
     */
    public function isTip()
    {
        return $this->tip;
    }

    /**
     * @param bool $tip
     *
     * @return Angebot
     */
    public function setTip($tip)
    {
        $this->tip = $tip;

        return $this;
    }

    /**
     * @return bool
     */
    public function isVFamily()
    {
        return $this->vFamily;
    }

    /**
     * @param bool $vFamily
     *
     * @return Angebot
     */
    public function setVFamily($vFamily)
    {
        $this->vFamily = $vFamily;

        return $this;
    }

    /**
     * @return bool
     */
    public function isBigOffer()
    {
        return $this->bigOffer;
    }

    /**
     * @param bool $bigOffer
     *
     * @return Angebot
     */
    public function setBigOffer($bigOffer)
    {
        $this->bigOffer = $bigOffer;

        return $this;
    }

    /**
     * @return Image
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param Image $picture
     *
     * @return Angebot
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;

        return $this;
    }

    /**
     * @return string
     */
    public function getOffertype()
    {
        return $this->offertype;
    }

    /**
     * @param string $offertype
     *
     * @return Angebot
     */
    public function setOffertype($offertype)
    {
        $this->offertype = $offertype;

        return $this;
    }


    /**
     * getFormattedPrice
     *
     * @param $locale
     *
     * @return string
     */
    public function getFormattedPrice($locale)
    {
        $numberFormatter = new \NumberFormatter($locale, \NumberFormatter::DECIMAL);

        $price = $this->price;
        if ($this->priceCustom > 0) {
            $price = $this->priceCustom;
        }

        return $numberFormatter->format($price);
    }

    /**
     * build
     *
     * @param VtoursDatenAngebot $offer
     * @param string             $language
     *
     * @return $this
     */
    public function build(VtoursDatenAngebot $offer, $language)
    {
        $this->hotelName = $offer->getHotelName();
        $this->location = $offer->getLocation();
        $this->country = $offer->getCountry();
        $this->category = $offer->getCategory();
        $this->maxTemperature = $offer->getMaxTemperature();

        $this->hotelPicture = new Image();
        if (!empty($offer->getHotelPicture())) {
            $this->hotelPicture->build($offer->getHotelPicture(), $language);
        }

        $this->offerId = $offer->getOfferID();


        $this->price = $offer->getPrice()->getValue();
        $this->priceUnit = $offer->getPrice()->getUnit()->getLongname();
        $this->priceUnitAbbreviation = $offer->getPrice()->getUnit()->getAbbreviation();


        $this->meal = $offer->getMeal();
        $this->roomType = $offer->getRoomType();
        $this->duration = $offer->getDuration();
        $this->flight = $offer->getFlight();
        $this->transfer = $offer->getTransfer();
        $this->deepLink = new Link();

        if (!empty($offer->getDeepLink())) {
            $this->deepLink->build($offer->getDeepLink());
        }

        if (!empty($offer->getPriceCustom())) {
            $this->priceCustom = $offer->getPriceCustom()->getValue();
            $this->priceCustomUnit = $offer->getPriceCustom()->getUnit()->getLongname();
            $this->priceCustomAbbreviation = $offer->getPriceCustom()->getUnit()->getAbbreviation();
        }

        $this->limitedOffer = $offer->getLimitedOffer();
        $this->tip = $offer->getTip();
        $this->vFamily = $offer->getVfamily();
        $this->bigOffer = $offer->getBigOffer();
        $this->picture = new Image();

        if (!empty($offer->getPicture())) {
            $this->picture->build($offer->getPicture(), $language);
        }

        $this->offertype = $offer->getCodeType();

        return $this;
    }
}
