<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class Text
 *
 * @package Vtours\Website\Model\Stages
 */
class Text extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'text.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $textLeft;

    /**
     * @var string
     */
    private $textRight;

    /**
     * @var string
     */
    private $textBottom;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return Text
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;
        return $this;
    }

    /**
     * @return string
     */
    public function getTextLeft()
    {
        return $this->textLeft;
    }

    /**
     * @param string $textLeft
     *
     * @return Text
     */
    public function setTextLeft($textLeft)
    {
        $this->textLeft = $textLeft;
        return $this;
    }

    /**
     * @return string
     */
    public function getTextRight()
    {
        return $this->textRight;
    }

    /**
     * @param string $textRight
     *
     * @return Text
     */
    public function setTextRight($textRight)
    {
        $this->textRight = $textRight;
        return $this;
    }

    /**
     * @return string
     */
    public function getTextBottom()
    {
        return $this->textBottom;
    }

    /**
     * @param string $textBottom
     *
     * @return Text
     */
    public function setTextBottom($textBottom)
    {
        $this->textBottom = $textBottom;
        return $this;
    }
}
