<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneSchnellbuchung;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Schnellbuchung;

/**
 * Class StageSchnellbuchung
 *
 * @package Vtours\Website\Mapper
 */
class StageSchnellbuchung implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneSchnellbuchung;
    }

    /**
     * handle
     *
     * @param VtoursBuehneSchnellbuchung $object
     * @param string                     $language
     *
     * @return Schnellbuchung
     */
    public function handle($object, $language)
    {
        return (new Schnellbuchung())
            ->setObjectId($object->getId())
            ->setTitle($object->getTitle($language));
    }
}
