<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class Topleiste
 *
 * @package Vtours\Website\Model\Stage
 */
class Topleiste extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'topleiste.twig';

    /**
     * @var array
     */
    private $elements = [];

    /**
     * @var string
     */
    private $labelMyBooking;

    /**
     * @return array
     */
    public function getElements()
    {
        return $this->elements;
    }

    /**
     * @param array $elements
     *
     * @return Topleiste
     */
    public function setElements($elements)
    {
        $this->elements = $elements;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabelMyBooking()
    {
        return $this->labelMyBooking;
    }

    /**
     * @param string $labelMyBooking
     *
     * @return Topleiste
     */
    public function setLabelMyBooking($labelMyBooking)
    {
        $this->labelMyBooking = $labelMyBooking;

        return $this;
    }
}
