<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneTextZweispaltigUndAufzaehlung;
use Vtours\Website\Model\Stage\TextZweispaltigAufzaehlung;

/**
 * Class StageTextZweispaltigAufzaehlung
 *
 * @package Vtours\Website\Mapper
 */
class StageTextZweispaltigAufzaehlung implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneTextZweispaltigUndAufzaehlung;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        $elements = $object->getEnumeration($language);

        $textElements = [];
        foreach ($elements as $element) {
            $textElements[] = $element['element']->getData();
        }

        return (new TextZweispaltigAufzaehlung())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setTextLeft($object->getContentLeft($language))
            ->setTextRight($object->getContentRight($language))
            ->setEnumeration($textElements);
    }
}
