<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Navigation;

/**
 * Class Route
 *
 * @package Vtours\Website\Model\Navigation
 */
class Route
{

    const STRIP_PATH = '/vtours/navigation';

    /**
     * @var int
     */
    private $routeId;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $path;

    /**
     * @var string
     */
    private $linkName;

    /**
     * @var Route
     */
    private $parent;

    /**
     * @var Route[]
     */
    private $siblings;

    /**
     * @return int
     */
    public function getRouteId()
    {
        return $this->routeId;
    }

    /**
     * @param int $routeId
     *
     * @return Route
     */
    public function setRouteId($routeId)
    {
        $this->routeId = $routeId;

        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return Route
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @param string $path
     *
     * @return Route
     */
    public function setPath($path)
    {
        $this->path = $path;

        return $this;
    }

    /**
     * @return string
     */
    public function getLinkName()
    {
        return $this->linkName;
    }

    /**
     * @param string $linkName
     *
     * @return Route
     */
    public function setLinkName($linkName)
    {
        $this->linkName = $linkName;

        return $this;
    }

    /**
     * @return Route
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * @param Route $parent
     *
     * @return Route
     */
    public function setParent($parent)
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * @return Route[]
     */
    public function getSiblings()
    {
        return $this->siblings;
    }

    /**
     * @param Route[] $siblings
     *
     * @return Route
     */
    public function setSiblings($siblings)
    {
        $this->siblings = $siblings;

        return $this;
    }
}
