<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneInformation;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\InformationElement;
use Vtours\Website\Model\Stage\Informationen;

/**
 * Class StageInformation
 *
 * @package Vtours\Website\Mapper
 */
class StageInformation implements HandlerInterface
{
    /**
     * handles
     *
     * @param VtoursBuehneInformation $object
     *
     * @return bool
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneInformation;
    }

    /**
     * handle
     *
     * @param VtoursBuehneInformation $object
     * @param string                  $language
     *
     * @return Informationen
     */
    public function handle($object, $language)
    {
        $elements = $object->getElements($language);

        $titleTextElements = [];
        foreach ($elements as $element) {
            $contentImage = new Image();
            if (!empty($element['contentImage'])) {
                $contentImage->build($element['contentImage']->getData(), $language);
            }

            $additionalContentImage = new Image();
            if (!empty($element['additionalContentImage'])) {
                $additionalContentImage->build($element['additionalContentImage']->getData(), $language);
            }

            $titleTextElements[] = (new InformationElement())
                ->setTitle($element['title']->getData())
                ->setContentImage($contentImage)
                ->setOrientationContentImage($element['orientationContentImage']->getData())
                ->setContent($element['content']->getData())
                ->setAdditionalContentImage($additionalContentImage)
                ->setOrientationAdditionalContentImage($element['orientationAdditionalContentImage']->getData())
                ->setAdditionalContent($element['additionalContent']->getData());
        }

        return (new Informationen())
            ->setObjectId($object->getId())
            ->setLabelClose($object->getLabelClose($language))
            ->setLabelOpen($object->getLabelOpen($language))
            ->setElements($titleTextElements);
    }
}
