<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneText;
use Vtours\Website\Model\Stage\Text;

/**
 * Class StageText
 *
 * @package Vtours\Website\Mapper
 */
class StageText implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneText;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        return (new Text())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTextTop($language))
            ->setTextLeft($object->getTextLeft($language))
            ->setTextRight($object->getTextRight($language))
            ->setTextBottom($object->getTextBottom($language));
    }
}
