<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;

/**
 * Class ReisezieleListeKarte
 *
 * @package Vtours\Website\Model\Stage
 */
class ReisezieleListeKarte extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'reiseziele-liste-karte.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $enumerationTitle;

    /**
     * @var Link[]
     */
    private $enumeration;

    /**
     * @var Image
     */
    private $mapPicture;

    /**
     * @var string
     */
    private $textLeft;

    /**
     * @var string
     */
    private $textRight;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return $this
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return string
     */
    public function getEnumerationTitle()
    {
        return $this->enumerationTitle;
    }

    /**
     * @param string $enumerationTitle
     *
     * @return $this
     */
    public function setEnumerationTitle($enumerationTitle)
    {
        $this->enumerationTitle = $enumerationTitle;

        return $this;
    }

    /**
     * @return Link[]
     */
    public function getEnumeration()
    {
        return $this->enumeration;
    }

    /**
     * @param Link[] $enumeration
     *
     * @return $this
     */
    public function setEnumeration($enumeration)
    {
        $this->enumeration = $enumeration;

        return $this;
    }

    /**
     * @return Image
     */
    public function getMapPicture()
    {
        return $this->mapPicture;
    }

    /**
     * @param Image $mapPicture
     *
     * @return $this
     */
    public function setMapPicture($mapPicture)
    {
        $this->mapPicture = $mapPicture;

        return $this;
    }

    /**
     * @return string
     */
    public function getTextLeft()
    {
        return $this->textLeft;
    }

    /**
     * @param string $textLeft
     *
     * @return $this
     */
    public function setTextLeft($textLeft)
    {
        $this->textLeft = $textLeft;

        return $this;
    }

    /**
     * @return string
     */
    public function getTextRight()
    {
        return $this->textRight;
    }

    /**
     * @param string $textRight
     *
     * @return $this
     */
    public function setTextRight($textRight)
    {
        $this->textRight = $textRight;

        return $this;
    }
}
