<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Link;

/**
 * Class TextButton
 *
 * @package Vtours\Website\Model\Stage
 */
class TextButton extends AbstractStage
{
    /**
     * @var string
     */
    protected $templateName = 'text-button.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $content;

    /**
     * @var Link[]
     */
    private $elements;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return TextButton
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string $content
     *
     * @return TextButton
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * @return Link[]
     */
    public function getElements()
    {
        return $this->elements;
    }

    /**
     * @param Link[] $elements
     *
     * @return TextButton
     */
    public function setElements($elements)
    {
        $this->elements = $elements;

        return $this;
    }
}
