<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneTextBild;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;
use Vtours\Website\Model\Stage\TextBild;

/**
 * Class StageTextBild
 *
 * @package Vtours\Website\Mapper
 */
class StageTextBild implements HandlerInterface
{
    /**
     * @inheritDoc
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneTextBild;
    }

    /**
     * @inheritDoc
     */
    public function handle($object, $language)
    {
        /**
         * @var \Pimcore\Model\Object\Data\Link $link
         */
        $link = $object->getLink($language);

        $linkModel = new Link();
        if (!empty($link)) {
            $linkModel->setTarget($link->getTarget())
                ->setHref($link->getHref())
                ->setTitle($link->getTitle())
                ->setText($link->getText());
        }

        $image = (new Image())->build($object->getPicture(), $language);

        return (new TextBild())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle($language))
            ->setContent($object->getContent($language))
            ->setLink($linkModel)
            ->setOrientation($object->getOrientation())
            ->setPicture($image);
    }
}
