<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Angebot;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Testimonial;

/**
 * Class Empfehlungen
 *
 * @package Vtours\Website\Model\Stage
 */
class Empfehlungen extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'empfehlungen.twig';

    /**
     * @var Testimonial
     */
    private $testimonial;

    /**
     * @var Angebot[]
     */
    private $offer;

    /**
     * @var boolean
     */
    private $showArrow;

    /**
     * @var string
     */
    private $position;

    /**
     * @var Image
     */
    private $backgroundPictureXS;

    /**
     * @var Image
     */
    private $backgroundPictureSM;

    /**
     * @var Image
     */
    private $backgroundPictureMD;

    /**
     * @var Image
     */
    private $backgroundPictureLG;

    /**
     * @return Testimonial
     */
    public function getTestimonial()
    {
        return $this->testimonial;
    }

    /**
     * @param Testimonial $testimonial
     *
     * @return $this
     */
    public function setTestimonial($testimonial)
    {
        $this->testimonial = $testimonial;

        return $this;
    }

    /**
     * @return Angebot[]
     */
    public function getOffer()
    {
        return $this->offer;
    }

    /**
     * @param Angebot[] $offer
     *
     * @return $this
     */
    public function setOffer($offer)
    {
        $this->offer = $offer;

        return $this;
    }

    /**
     * @return bool
     */
    public function isShowArrow()
    {
        return $this->showArrow;
    }

    /**
     * @param bool $showArrow
     *
     * @return Empfehlungen
     */
    public function setShowArrow($showArrow)
    {
        $this->showArrow = $showArrow;

        return $this;
    }

    /**
     * @return string
     */
    public function getPosition()
    {
        return $this->position;
    }

    /**
     * @param string $position
     *
     * @return Empfehlungen
     */
    public function setPosition($position)
    {
        $this->position = $position;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureXS()
    {
        return $this->backgroundPictureXS;
    }

    /**
     * @param Image $backgroundPictureXS
     *
     * @return Empfehlungen
     */
    public function setBackgroundPictureXS($backgroundPictureXS)
    {
        $this->backgroundPictureXS = $backgroundPictureXS;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureSM()
    {
        return $this->backgroundPictureSM;
    }

    /**
     * @param Image $backgroundPictureSM
     *
     * @return Empfehlungen
     */
    public function setBackgroundPictureSM($backgroundPictureSM)
    {
        $this->backgroundPictureSM = $backgroundPictureSM;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureMD()
    {
        return $this->backgroundPictureMD;
    }

    /**
     * @param Image $backgroundPictureMD
     *
     * @return Empfehlungen
     */
    public function setBackgroundPictureMD($backgroundPictureMD)
    {
        $this->backgroundPictureMD = $backgroundPictureMD;

        return $this;
    }

    /**
     * @return Image
     */
    public function getBackgroundPictureLG()
    {
        return $this->backgroundPictureLG;
    }

    /**
     * @param Image $backgroundPictureLG
     *
     * @return Empfehlungen
     */
    public function setBackgroundPictureLG($backgroundPictureLG)
    {
        $this->backgroundPictureLG = $backgroundPictureLG;

        return $this;
    }

    /**
     * getBackgroundPicture
     *
     * @param string $size
     *
     * @return Image
     */
    public function getBackgroundPicture($size)
    {
        $size = strtolower($size);

        $picture = $this->backgroundPictureLG;

        if ($size == 'md') {
            $picture = (empty($this->backgroundPictureMD->getUrl()) ? $this->backgroundPictureLG : $this->backgroundPictureMD);
        }

        if ($size == 'sm') {
            if (!empty($this->backgroundPictureSM->getUrl())) {
                $picture = $this->backgroundPictureSM;
            } elseif (!empty($this->backgroundPictureMD->getUrl())) {
                $picture = $this->backgroundPictureMD;
            }
        }

        if ($size == 'xs') {
            if (!empty($this->backgroundPictureXS->getUrl())) {
                $picture = $this->backgroundPictureXS;
            } elseif (!empty($this->backgroundPictureSM->getUrl())) {
                $picture = $this->backgroundPictureSM;
            } elseif (!empty($this->backgroundPictureMD->getUrl())) {
                $picture = $this->backgroundPictureMD;
            }
        }

        return $picture;
    }
}
