<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class Iframe
 *
 * @package Vtours\Website\Model\Stage
 */
class Iframe extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'iframe.twig';

    /**
     * @var string
     */
    private $url;

    /**
     * @var string
     */
    private $queryParam;

    /**
     * @var boolean
     */
    private $autoheight;

    /**
     * @return string
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param string $url
     *
     * @return Iframe
     */
    public function setUrl($url)
    {
        $this->url = $url;

        return $this;
    }

    /**
     * @return string
     */
    public function getQueryParam()
    {
        return $this->queryParam;
    }

    /**
     * @param string $queryParam
     *
     * @return Iframe
     */
    public function setQueryParam($queryParam)
    {
        $this->queryParam = $queryParam;

        return $this;
    }

    /**
     * @return boolean
     */
    public function isAutoheight()
    {
        return $this->autoheight;
    }

    /**
     * @param boolean $autoheight
     *
     * @return Iframe
     */
    public function setAutoheight($autoheight)
    {
        $this->autoheight = $autoheight;

        return $this;
    }
}
