<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;

/**
 * Class Nutzerversprechen
 *
 * @package Vtours\Website\Model\Stage
 */
class Nutzerversprechen extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'nutzerversprechen.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $icon1;

    /**
     * @var string
     */
    private $icon2;

    /**
     * @var string
     */
    private $icon3;

    /**
     * @var string
     */
    private $icon4;

    /**
     * @var Link
     */
    private $link1;

    /**
     * @var Link
     */
    private $link2;

    /**
     * @var Link
     */
    private $link3;

    /**
     * @var Link
     */
    private $link4;

    /**
     * @var string
     */
    private $text;

    /**
     * @var Image
     */
    private $picture;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return Nutzerversprechen
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return string
     */
    public function getIcon1()
    {
        return $this->icon1;
    }

    /**
     * @param string $icon1
     *
     * @return Nutzerversprechen
     */
    public function setIcon1($icon1)
    {
        $this->icon1 = $icon1;

        return $this;
    }

    /**
     * @return string
     */
    public function getIcon2()
    {
        return $this->icon2;
    }

    /**
     * @param string $icon2
     *
     * @return Nutzerversprechen
     */
    public function setIcon2($icon2)
    {
        $this->icon2 = $icon2;

        return $this;
    }

    /**
     * @return string
     */
    public function getIcon3()
    {
        return $this->icon3;
    }

    /**
     * @param string $icon3
     *
     * @return Nutzerversprechen
     */
    public function setIcon3($icon3)
    {
        $this->icon3 = $icon3;

        return $this;
    }

    /**
     * @return string
     */
    public function getIcon4()
    {
        return $this->icon4;
    }

    /**
     * @param string $icon4
     *
     * @return Nutzerversprechen
     */
    public function setIcon4($icon4)
    {
        $this->icon4 = $icon4;

        return $this;
    }

    /**
     * @return Link
     */
    public function getLink1()
    {
        return $this->link1;
    }

    /**
     * @param Link $link1
     *
     * @return Nutzerversprechen
     */
    public function setLink1($link1)
    {
        $this->link1 = $link1;

        return $this;
    }

    /**
     * @return Link
     */
    public function getLink2()
    {
        return $this->link2;
    }

    /**
     * @param Link $link2
     *
     * @return Nutzerversprechen
     */
    public function setLink2($link2)
    {
        $this->link2 = $link2;

        return $this;
    }

    /**
     * @return Link
     */
    public function getLink3()
    {
        return $this->link3;
    }

    /**
     * @param Link $link3
     *
     * @return Nutzerversprechen
     */
    public function setLink3($link3)
    {
        $this->link3 = $link3;

        return $this;
    }

    /**
     * @return Link
     */
    public function getLink4()
    {
        return $this->link4;
    }

    /**
     * @param Link $link4
     *
     * @return Nutzerversprechen
     */
    public function setLink4($link4)
    {
        $this->link4 = $link4;

        return $this;
    }

    /**
     * @return string
     */
    public function getText()
    {
        return $this->text;
    }

    /**
     * @param string $text
     *
     * @return Nutzerversprechen
     */
    public function setText($text)
    {
        $this->text = $text;

        return $this;
    }

    /**
     * @return Image
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param Image $picture
     *
     * @return Nutzerversprechen
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;

        return $this;
    }
}
