<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\TravelDestination;

/**
 * Class ReisezieleSlider
 *
 * @package Vtours\Website\Model\Stages
 */
class ReisezieleSlider extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'reiseziele-slider.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var TravelDestination[]
     */
    private $elements;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return ReisezieleSlider
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;
        return $this;
    }

    /**
     * @return TravelDestination[]
     */
    public function getElements()
    {
        return $this->elements;
    }

    /**
     * @param TravelDestination[] $elements
     *
     * @return ReisezieleSlider
     */
    public function setElements($elements)
    {
        $this->elements = $elements;
        return $this;
    }
}
