<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\InformationElement;

/**
 * Class Informationen
 *
 * @package Vtours\Website\Model\Stage
 */
class Informationen extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'informationen.twig';

    /**
     * @var string
     */
    private $labelClose;

    /**
     * @var string
     */
    private $labelOpen;

    /**
     * @var InformationElement[]
     */
    private $elements;

    /**
     * @return string
     */
    public function getLabelClose()
    {
        return $this->labelClose;
    }

    /**
     * @param string $labelClose
     *
     * @return Informationen
     */
    public function setLabelClose($labelClose)
    {
        $this->labelClose = $labelClose;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabelOpen()
    {
        return $this->labelOpen;
    }

    /**
     * @param string $labelOpen
     *
     * @return Informationen
     */
    public function setLabelOpen($labelOpen)
    {
        $this->labelOpen = $labelOpen;

        return $this;
    }

    /**
     * @return InformationElement[]
     */
    public function getElements()
    {
        return $this->elements;
    }

    /**
     * @param InformationElement[] $elements
     *
     * @return Informationen
     */
    public function setElements($elements)
    {
        $this->elements = $elements;

        return $this;
    }
}
