<?php

namespace Vtours\Website\Model\Stage;

use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;

/**
 * Class TextBild
 *
 * @package Vtours\Website\Model\Stage
 */
class TextBild extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'text-bild.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $content;

    /**
     * @var Link
     */
    private $link;

    /**
     * @var string
     */
    private $orientation;

    /**
     * @var Image
     */
    private $picture;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return TextBild
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return string
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param string $content
     *
     * @return TextBild
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * @return Link
     */
    public function getLink()
    {
        return $this->link;
    }

    /**
     * @param Link $link
     *
     * @return TextBild
     */
    public function setLink($link)
    {
        $this->link = $link;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrientation()
    {
        return $this->orientation;
    }

    /**
     * @param string $orientation
     *
     * @return TextBild
     */
    public function setOrientation($orientation)
    {
        $this->orientation = $orientation;

        return $this;
    }

    /**
     * @return Image
     */
    public function getPicture()
    {
        return $this->picture;
    }

    /**
     * @param Image $picture
     *
     * @return TextBild
     */
    public function setPicture($picture)
    {
        $this->picture = $picture;

        return $this;
    }
}
