<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneBeschwerdeFormular;
use Vtours\Website\Model\Stage\BeschwerdeFormular;


class StageBeschwerdeFormular implements HandlerInterface
{
    /**
     * handles
     *
     * @param VtoursBuehneBeschwerdeFormular $object
     *
     * @return bool
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneBeschwerdeFormular;
    }

    /**
     * handle
     *
     * @param VtoursBuehneBeschwerdeFormular $object
     * @param string               $language
     *
     * @return Formular
     */
    public function handle($object, $language)
    {
        return (new BeschwerdeFormular())
            ->setObjectId($object->getId())
            ->setTitle($object->getTitle())
            ->setFormAction($object->getFormAction())
            ->setSalutation($object->getSalutation())
            ->setFirstName($object->getFirstName())
            ->setLastName($object->getLastName())
            ->setEmail($object->getEmail())
            ->setTelephone($object->getTelefon())
            ->setBookingNumber($object->getBookingNumber())
            ->setMessage($object->getMessage());
    }
}
