<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Mapper\Handler;

use Pimcore\Model\Object\VtoursBuehneNutzerversprechen;
use Vtours\Website\Model\Stage\Element\Image;
use Vtours\Website\Model\Stage\Element\Link;
use Vtours\Website\Model\Stage\Nutzerversprechen;

/**
 * Class StagePromise
 *
 * @package Vtours\Website\Mapper
 */
class StagePromise implements HandlerInterface
{
    /**
     * handles
     *
     * @param VtoursBuehneNutzerversprechen $object
     *
     * @return bool
     */
    public function handles($object)
    {
        return $object instanceof VtoursBuehneNutzerversprechen;
    }

    /**
     * handle
     *
     * @param VtoursBuehneNutzerversprechen $object
     * @param string                        $language
     *
     * @return Nutzerversprechen
     */
    public function handle($object, $language)
    {
        $image = (new Image())->build($object->getRingPicture(), $language);

        $linkModel1 = (new Link())->build($object->getLink1());
        $linkModel2 = (new Link())->build($object->getLink2());
        $linkModel3 = (new Link())->build($object->getLink3());
        $linkModel4 = (new Link())->build($object->getLink4());

        return (new Nutzerversprechen())
            ->setObjectId($object->getId())
            ->setStageTitle($object->getTitle())
            ->setIcon1($object->getIcon1())
            ->setLink1($linkModel1)
            ->setIcon2($object->getIcon2())
            ->setLink2($linkModel2)
            ->setIcon3($object->getIcon3())
            ->setLink3($linkModel3)
            ->setIcon4($object->getIcon4())
            ->setLink4($linkModel4)
            ->setText($object->getRingText())
            ->setPicture($image);
    }
}
