<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class BeschwerdeFormular
 * @package Vtours\Website\Model\Stage
 */
class BeschwerdeFormular extends AbstractStage
{
    /**
     * @var string
     */
    protected $templateName = 'formular-complaint-requests.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $title;

    /**
     * @var string
     */
    private $formAction;

    /**
     * @var string
     */
    private $salutation;

    /**
     * @var string
     */
    private $firstName;

    /**
     * @var string
     */
    private $lastName;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $phone;

    /**
     * @var string
     */
    private $street;

    /**
     * @var string
     */
    private $houseNumber;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $postalCode;

    /**
     * @var string
     */
    private $country;

    /**
     * @var string
     */
    private $arrivalDate;

    /**
     * @var string
     */
    private $complaint;

    /**
     * @var string
     */
    private $complaintOptions;

    /**
     * @var string
     */
    private $protocol;

    /**
     * @var string
     */
    private $compensation;

    /**
     * @var string
     */
    private $complaintDate;

    /**
     * @var string
     */
    private $message;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     * @return BeschwerdeFormular
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $title
     * @return BeschwerdeFormular
     */
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    /**
     * @return string
     */
    public function getFormAction()
    {
        return $this->formAction;
    }

    /**
     * @param string $formAction
     * @return BeschwerdeFormular
     */
    public function setFormAction($formAction)
    {
        $this->formAction = $formAction;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getSalutation()
    {
        return $this->salutation;
    }

    /**
     * @param mixed $salutation
     * @return BeschwerdeFormular
     */
    public function setSalutation($salutation)
    {
        $this->salutation = $salutation;
        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return BeschwerdeFormular
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param mixed $lastName
     * @return BeschwerdeFormular
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @param mixed $street
     * @return BeschwerdeFormular
     */
    public function setStreet($street)
    {
        $this->street = $street;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getHouseNumber()
    {
        return $this->houseNumber;
    }

    /**
     * @param mixed $houseNumber
     * @return BeschwerdeFormular
     */
    public function setHouseNumber($houseNumber)
    {
        $this->houseNumber = $houseNumber;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param mixed $city
     * @return BeschwerdeFormular
     */
    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param mixed $country
     * @return BeschwerdeFormular
     */
    public function setCountry($country)
    {
        $this->country = $country;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param mixed $message
     * @return BeschwerdeFormular
     */
    public function setMessage($message)
    {
        $this->message = $message;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return BeschwerdeFormular
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     * @return BeschwerdeFormular
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return string
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }

    /**
     * @param string $postalCode
     * @return BeschwerdeFormular
     */
    public function setPostalCode($postalCode)
    {
        $this->postalCode = $postalCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getArrivalDate()
    {
        return $this->arrivalDate;
    }

    /**
     * @param string $arrivalDate
     * @return BeschwerdeFormular
     */
    public function setArrivalDate($arrivalDate)
    {
        $this->arrivalDate = $arrivalDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getComplaint()
    {
        return $this->complaint;
    }

    /**
     * @param string $complaint
     * @return BeschwerdeFormular
     */
    public function setComplaint($complaint)
    {
        $this->complaint = $complaint;
        return $this;
    }

    /**
     * @return string
     */
    public function getComplaintOptions()
    {
        return $this->complaintOptions;
    }

    /**
     * @param string $complaintOptions
     * @return BeschwerdeFormular
     */
    public function setComplaintOptions($complaintOptions)
    {
        $this->complaintOptions = $complaintOptions;
        return $this;
    }

    /**
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }

    /**
     * @param string $protocol
     * @return BeschwerdeFormular
     */
    public function setProtocol($protocol)
    {
        $this->protocol = $protocol;
        return $this;
    }

    /**
     * @return string
     */
    public function getCompensation()
    {
        return $this->compensation;
    }

    /**
     * @param string $compensation
     * @return BeschwerdeFormular
     */
    public function setCompensation($compensation)
    {
        $this->compensation = $compensation;
        return $this;
    }

    /**
     * @return string
     */
    public function getComplaintDate()
    {
        return $this->complaintDate;
    }

    /**
     * @param string $complaintDate
     * @return BeschwerdeFormular
     */
    public function setComplaintDate($complaintDate)
    {
        $this->complaintDate = $complaintDate;
        return $this;
    }
}
