<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license is a violation of the license agreement
 * and will be prosecuted by civil and criminal law.
 *
 * @copyright 2017 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Vtours\Website\Model\Stage;

/**
 * Class KontaktFormular
 *
 * @package Vtours\Website\Model\Stage
 */
class KontaktFormular extends AbstractStage
{

    /**
     * @var string
     */
    protected $templateName = 'kontakt-formular.twig';

    /**
     * @var string
     */
    private $stageTitle;

    /**
     * @var string
     */
    private $salutation;

    /**
     * @var string
     */
    private $labelChoose;

    /**
     * @var string
     */
    private $salutationMr;

    /**
     * @var string
     */
    private $salutationMs;

    /**
     * @var string
     */
    private $firstName;

    /**
     * @var string
     */
    private $lastName;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $telephone;

    /**
     * @var string
     */
    private $fax;

    /**
     * @var string
     */
    private $bookingSource;

    /**
     * @var array
     */
    private $bookingSourceOptions;

    /**
     * @var string
     */
    private $bookingNumber;

    /**
     * @var string
     */
    private $subject;

    /**
     * @var array
     */
    private $subjectOptions;

    /**
     * @var string
     */
    private $message;

    /**
     * @var string
     */
    private $labelButton;

    /**
     * @return string
     */
    public function getStageTitle()
    {
        return $this->stageTitle;
    }

    /**
     * @param string $stageTitle
     *
     * @return KontaktFormular
     */
    public function setStageTitle($stageTitle)
    {
        $this->stageTitle = $stageTitle;

        return $this;
    }

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }

    /**
     * @param string $salutation
     *
     * @return KontaktFormular
     */
    public function setSalutation($salutation)
    {
        $this->salutation = $salutation;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabelChoose()
    {
        return $this->labelChoose;
    }

    /**
     * @param string $labelChoose
     *
     * @return KontaktFormular
     */
    public function setLabelChoose($labelChoose)
    {
        $this->labelChoose = $labelChoose;

        return $this;
    }

    /**
     * @return string
     */
    public function getSalutationMr()
    {
        return $this->salutationMr;
    }

    /**
     * @param string $salutationMr
     *
     * @return KontaktFormular
     */
    public function setSalutationMr($salutationMr)
    {
        $this->salutationMr = $salutationMr;

        return $this;
    }

    /**
     * @return string
     */
    public function getSalutationMs()
    {
        return $this->salutationMs;
    }

    /**
     * @param string $salutationMs
     *
     * @return KontaktFormular
     */
    public function setSalutationMs($salutationMs)
    {
        $this->salutationMs = $salutationMs;

        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     *
     * @return KontaktFormular
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;

        return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     *
     * @return KontaktFormular
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;

        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     *
     * @return KontaktFormular
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * @param string $telephone
     *
     * @return KontaktFormular
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * @param string $fax
     *
     * @return KontaktFormular
     */
    public function setFax($fax)
    {
        $this->fax = $fax;

        return $this;
    }

    /**
     * @return string
     */
    public function getBookingSource()
    {
        return $this->bookingSource;
    }

    /**
     * @param string $bookingSource
     *
     * @return KontaktFormular
     */
    public function setBookingSource($bookingSource)
    {
        $this->bookingSource = $bookingSource;

        return $this;
    }

    /**
     * @return string
     */
    public function getBookingNumber()
    {
        return $this->bookingNumber;
    }

    /**
     * @param string $bookingNumber
     *
     * @return KontaktFormular
     */
    public function setBookingNumber($bookingNumber)
    {
        $this->bookingNumber = $bookingNumber;

        return $this;
    }

    /**
     * @return string
     */
    public function getSubject()
    {
        return $this->subject;
    }

    /**
     * @param string $subject
     *
     * @return KontaktFormular
     */
    public function setSubject($subject)
    {
        $this->subject = $subject;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     *
     * @return KontaktFormular
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * @return string
     */
    public function getLabelButton()
    {
        return $this->labelButton;
    }

    /**
     * @param string $labelButton
     *
     * @return KontaktFormular
     */
    public function setLabelButton($labelButton)
    {
        $this->labelButton = $labelButton;

        return $this;
    }

    /**
     * @return array
     */
    public function getBookingSourceOptions()
    {
        return $this->bookingSourceOptions;
    }

    /**
     * @param array $bookingSourceOptions
     *
     * @return KontaktFormular
     */
    public function setBookingSourceOptions($bookingSourceOptions)
    {
        $this->bookingSourceOptions = $bookingSourceOptions;
        return $this;
    }

    /**
     * @return array
     */
    public function getSubjectOptions()
    {
        return $this->subjectOptions;
    }

    /**
     * @param array $subjectOptions
     *
     * @return KontaktFormular
     */
    public function setSubjectOptions($subjectOptions)
    {
        $this->subjectOptions = $subjectOptions;
        return $this;
    }
}
